//methods for Particle class. The positions of the particles are integrated at each time step in the integrate() function below.x
#include "Verlet/Particle.h"

Particle::Particle () {}

Particle::Particle ( const double x, const double y, const double z, const double vx, const double vy, const double vz ) {
   m_x = x;
   m_y = y;
   m_z = z;
   m_vx = vx;
   m_vy = vy;
   m_vz = vz;
   m_xForce = 0.0;
   m_yForce = 0.0;
   m_zForce = 0.0;
}

Particle::~Particle () {}

double Particle::Getx () {
   return m_x;
}

double Particle::Gety () {
   return m_y;
}

double Particle::Getz () {
   return m_z;
}

double Particle::Getprevx() {
   return m_prevx;
}

double Particle::Getprevy() {
   return m_prevy;
}

double Particle::Getprevz() {
   return m_prevz;
}

double Particle::Getvx () {
   return m_vx;
}

double Particle::Getvy () {
   return m_vy;
}

double Particle::Getvz () {
   return m_vz;
}

void Particle::Setvx ( const double vx ) {
   m_vx = vx;
}

void Particle::Setvy ( const double vy ) {
   m_vy = vy;
}

void Particle::Setvz ( const double vz ) {
   m_vz = vz;
}

void Particle::SetPrevx ( const double prevx ) {
   m_prevx = prevx;
}

void Particle::SetPrevy ( const double prevy ) {
   m_prevy = prevy;
}

void Particle::SetPrevz ( const double prevz ) {
   m_prevz = prevz;
}

void Particle::updateXforce ( const double xForce ) {
   m_xForce += xForce;
}

void Particle::updateYforce ( const double yForce ) {
   m_yForce += yForce;
}

void Particle::updateZforce ( const double zForce ) {
   m_zForce += zForce;
}

void Particle::zeroForce () {
   m_xForce = 0.0;
   m_yForce = 0.0;
   m_zForce = 0.0;
}

double Particle::GetXforce () {
   return m_xForce;
}

double Particle::GetYforce () {
   return m_yForce;
}

double Particle::GetZforce () {
   return m_zForce;
}

void Particle::integrate ( double timeStep ) {

   //compute next positions.
   double nextx = 2*m_x - m_prevx + timeStep*timeStep*m_xForce;
   m_vx = (nextx - m_prevx)/(2*timeStep);
   double nexty = 2*m_y - m_prevy + timeStep*timeStep*m_yForce;
   m_vy = (nexty - m_prevy)/(2*timeStep);
   double nextz = 2*m_z - m_prevz + timeStep*timeStep*m_zForce;
   m_vz = (nextz - m_prevz)/(2*timeStep);


   //calculate kinetic energy.
   m_kineticEnergy = 0.5*(m_vx*m_vx+m_vy*m_vy+m_vz*m_vz);

   //update current and previous positions.
   m_prevx = m_x;
   m_x = nextx;
   m_prevy = m_y;
   m_y = nexty;
   m_prevz = m_z;
   m_z = nextz;

}

double Particle::GetKineticEnergy () {
    return m_kineticEnergy;
}
