//The main algorithm for the Verlet molecular dynamics code. Dynamically allocate your external sampling functions below using "externalFuncs.push_back( &MyExternalFunction );" The function will then be executed in the main molecular dynamics loop of the code.
#include "Verlet/Verlet.h"
#include "Verlet/FunctionPtr.h"
#include "Verlet/Energy.h"
#include "Verlet/RadialDistribution.h"
#include <stdlib.h>
#include <time.h>

int main() {
   	
    srand ( time( NULL ) );
    vector<FunctionPtr> externalFuncs;
    externalFuncs.push_back( &Energy );
    externalFuncs.push_back( &RadialDistribution );

    Verlet * myVerlet = new Verlet();
    myVerlet->Initialize();
    myVerlet->Integrate( externalFuncs );

    delete myVerlet;

    return 0;

}


