//a routine for plotting output of the FlyvbjergPetersen.C code. This routine can be run inside of ROOT, which is a plotting package distributed by CERN at http://root.cern.ch/
{
   gROOT->Reset();

   FILE * errorEstimate = fopen( "ErrorEstimate.dat", "r" );

#include <vector>   
#include <math.h>
   vector<double> errorEstimates;
   vector<double> sigmaErrorEstimates;
   double error;
   double sigmaError;

   while ( !feof( errorEstimate ) ) {
      if ( !feof( errorEstimate )  ) {
         fscanf( errorEstimate, "%lf %lf", &error, &sigmaError );
         errorEstimates.push_back( error );
         sigmaErrorEstimates.push_back( sigmaError );
	 printf( "%e %e\n", error, sigmaError );
      }
   }

   fclose( errorEstimate );

   const int errorSize = errorEstimates.size()-1;

   float errorsToPlot[errorSize];
   float sigmaErrorsToPlot[errorSize];
   float xAxis[errorSize];
   float xErrors[errorSize];

   for ( int i=0; i<errorSize; i++ ) {
      errorsToPlot[i] = ((float)(errorEstimates[i]));
      sigmaErrorsToPlot[i] = ((float)(sigmaErrorEstimates[i]));
      xAxis[i] = ((float)(i));
      xErrors[i] = 0.0;
   }

   TCanvas * c1 = new TCanvas( "c1", "errors" );

   TGraphErrors * errorGraph = new TGraphErrors( errorSize, xAxis, errorsToPlot, xErrors, sigmaErrorsToPlot );
   errorGraph->SetMarkerStyle(kOpenCircle);
   errorGraph->SetTitle( "sigma vs. M" );
   (errorGraph->GetXaxis())->SetTitle( "M");
   (errorGraph->GetYaxis())->SetTitle("sigma");
   errorGraph->Draw("AP");

}
