//A routine for plotting the kinetic energy, potential energy, and total energy data output by the Verlet.exe executable. This code can be run inside of ROOT, which is a plotting package distributed by CERN at http://root.cern.ch/
{
   gROOT->Reset();

   const Int_t NUMBER_OF_POINTS = 1024;

   Float_t kineticEnergy[NUMBER_OF_POINTS];
   Float_t potentialEnergy[NUMBER_OF_POINTS];
   Float_t totalEnergy[NUMBER_OF_POINTS];
   Float_t timeStep[NUMBER_OF_POINTS];

   fstream * energyFile = new fstream( "Energy.dat", ios_base::in );

   Int_t count = 0;

   while ( !energyFile->eof() ) {
       *energyFile >> kineticEnergy[count] >> potentialEnergy[count] >> totalEnergy[count] >> ws;
       timeStep[count] = ((float)(count));	
       count++;
   }

   //TCanvas * c1 = new TCanvas( "c1", "Energy vs. Time Step" );
   TGraph * keGraph = new TGraph( count, timeStep, kineticEnergy );
   keGraph->SetTitle( "kinetic energy vs. timestep" );
   (*((*keGraph).GetXaxis())).SetTitle( "time step" );
   (*((*keGraph).GetYaxis())).SetTitle( "kinetic energy per particle" );

   //keGraph->Draw("ALP");

   //TCanvas * c2 = new TCanvas( "c2", "PE vs. Time Step" );
	
   TGraph * peGraph = new TGraph( count, timeStep, potentialEnergy );
   peGraph->SetTitle("potential energy vs. time step");
   (*((*peGraph).GetXaxis())).SetTitle( "time step" );
   (*((*peGraph).GetYaxis())).SetTitle( "potential energy" );

   //peGraph->Draw("ALP");

   //TCanvas * c3 = new TCanvas( "c3", "Total Energy vs. Time Step" );

   TGraph * totalE = new TGraph( count, timeStep, totalEnergy );
   totalE->SetTitle("total energy vs. time step");
   (*((*totalE).GetXaxis())).SetTitle( "time step" );
   (*((*totalE).GetYaxis())).SetTitle( "total energy" );
 
   //totalE->Draw("ALP");

   TCanvas * c4 = new TCanvas( "c4", "Energy Graphs" );
   Float_t dummyX[2] = { 0.0, ((float)(NUMBER_OF_POINTS)) };
   Float_t dummyY[2] = { 2.0, -6.0 };
   TGraph * dummyGraph = new TGraph( 2, dummyX, dummyY );
   dummyGraph->SetMarkerStyle(kDot);
   dummyGraph->SetTitle( "energy per particle vs. time step" );
   (*((*dummyGraph).GetXaxis())).SetTitle( "time step" );
   (*((*dummyGraph).GetYaxis())).SetTitle( "energy per particle" );
   dummyGraph->Draw("AP"); 
   keGraph->SetLineColor(3);
   peGraph->SetLineColor(4);
   totalE->SetLineStyle(4);
   keGraph->Draw("LP");
   peGraph->Draw("LP");   
   totalE->Draw("LP");

}

