//Verlet class definition for Verlet molecular simulation code. The Verlet class methods implement most of the important parts of the Verlet algorithm.
#ifndef VERLET_H
#define VERLET_H

#include <vector.h>
#include "Verlet/Particle.h"
#include "Verlet/FunctionPtr.h"

class Verlet {

   public:
      Verlet();
      Verlet( const double temperature, const int numberOfParticles, const double density, const double timeStep, const int numberOfTimeSteps );
      ~Verlet();
      void Initialize();
      void Integrate( vector<FunctionPtr> externalFunctions );

   private:
      double m_temperature;
      int  m_numberOfParticles;
      double m_density;
      double m_timeStep;
      vector<Particle> m_particleVector;
      double m_bigEdge;
      double m_littleEdge;
      int m_numberOfTimeSteps;
};

#endif
