//definition of the Particle class used in Verlet molecular simulation program.
#ifndef PARTICLE_H
#define PARTICLE_H

class Particle {
    
   public:
      Particle();
      Particle( const double x, const double y, const double z, const double vx, const double vy, const double vz );
      ~Particle();
      double Getx();
      double Gety();
      double Getz();
      double Getprevx();
      double Getprevy();
      double Getprevz();
      double Getvx();
      double Getvy();
      double Getvz();
      double GetXforce();
      double GetYforce();
      double GetZforce();
      double GetKineticEnergy();
      void Setvx( const double vx );
      void Setvy( const double vy );
      void Setvz( const double vz );
      void SetPrevx( const double prevx );
      void SetPrevy( const double prevy );
      void SetPrevz( const double prevz );
      void updateXforce( const double xForce );
      void updateYforce( const double yForce );
      void updateZforce( const double zForce );
      void zeroForce();
      void integrate( double timeStep );

   private:
      double m_x;
      double m_y;
      double m_z;
      double m_vx;
      double m_vy;
      double m_vz;
      double m_prevx;
      double m_prevy;
      double m_prevz;
      double m_potentialEnergy;
      double m_kineticEnergy;
      double m_totalEnergy;
      double m_xForce;
      double m_yForce;
      double m_zForce;

};

#endif
