#ifndef ENERGY_H
#define ENERGY_H

#include "Verlet/Particle.h"
#include <vector.h>
#include <fstream.h>
#include <math.h>

void Energy ( double * temperature, int * numberOfParticles, double * density, double * timeStep, vector<Particle> * particleVector, double * bigEdge, double * littleEdge, int * numberOfTimeSteps, int * thisTimeStep ) {

   //remove output file "Energy.dat" if it already exists. 
   if ( *thisTimeStep == 0 ) {
      ofstream outFile( "output/Energy.dat", ios::out );
      outFile.close();
   }

   ofstream outFile( "output/Energy.dat", ios::app );

   //average kinetic energy calculation.
   double averageKineticEnergy = 0.0;

   for ( vector<Particle>::iterator particle = particleVector->begin(); particle != particleVector->end(); particle++ ) {
       averageKineticEnergy += particle->GetKineticEnergy();
   }
//   cout << "T = " << 2./3.*averageKineticEnergy/((double)(*numberOfParticles)) << endl;
   
   averageKineticEnergy /= ((double)(*numberOfParticles));
  
   //average potential energy calculation.

   double separationx = 0.0;
   double separationy = 0.0;
   double separationz = 0.0;
   double separationSquared = 0.0;
   double averagePotentialEnergy = 0.0;

   for ( vector<Particle>::iterator i = particleVector->begin(); i != particleVector->end()-1; i++ ) {
     for ( vector<Particle>::iterator j = i+1; j != particleVector->end(); j++ ) {
	separationx = (i->Getprevx()-j->Getprevx());
	separationx -= *bigEdge*rint(separationx/(*bigEdge));
	separationy = (i->Getprevy()-j->Getprevy());
	separationy -= *bigEdge*rint(separationy/(*bigEdge));
	separationz = (i->Getprevz()-j->Getprevz());
	separationz -= *bigEdge*rint(separationz/(*bigEdge));
	separationSquared = (separationx*separationx)+(separationy*separationy)+(separationz*separationz);
	averagePotentialEnergy += 4.*(pow( separationSquared, -6.0 )-pow( separationSquared, -3.0 ));
      }
   }

   averagePotentialEnergy /= ((double)(*numberOfParticles));
   averagePotentialEnergy -= 4.*(pow( *bigEdge/2., -12.0 )-pow( *bigEdge/2., -6.0 ));

   outFile << averageKineticEnergy << "  " << averagePotentialEnergy << "  " << averageKineticEnergy+averagePotentialEnergy << endl;

   outFile.close();

}

#endif
